{{-- resources/views/talenta/sandbox/employees/create.blade.php --}}
@extends('layouts.app')
@section('title','Sandbox – Employees')
@section('page-title','Buat Karyawan (Sandbox)')

@section('content')
<div class="max-w-6xl mx-auto">
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 px-5 py-4 mb-5 flex items-center justify-between">
        <div>
            <h2 class="text-lg font-semibold text-gray-900">Tambah Karyawan – Sandbox</h2>
            <p class="text-sm text-gray-500">
                Lengkapi informasi personal & employment. Kolom bertanda
                <span class="text-red-600">*</span> wajib diisi.
            </p>
        </div>
        <a href="{{ route('talenta.sandbox.employees.index') }}"
           class="inline-flex items-center gap-2 text-sm px-3 py-2 rounded-xl border border-gray-200 hover:bg-gray-50">
           ← Kembali
        </a>
    </div>

    @if($errors->any())
        <div class="mb-5 rounded-xl border border-red-200 bg-red-50 text-red-700 px-4 py-3">
            <div class="font-semibold mb-1">Form belum lengkap</div>
            <ul class="list-disc ml-5 text-sm">
                @foreach($errors->all() as $e)
                    <li>{{ $e }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('talenta.sandbox.employees.store') }}" method="POST" class="space-y-6">
        @csrf

        {{-- ================= PERSONAL ================= --}}
        <section class="bg-white rounded-2xl shadow-sm border border-gray-100">
            <div class="px-5 py-4 border-b border-gray-100">
                <h3 class="font-semibold text-gray-900">Informasi Personal</h3>
                <p class="text-sm text-gray-500">Data dasar karyawan.</p>
            </div>

            <div class="p-5 grid grid-cols-1 md:grid-cols-2 gap-5">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Employee ID <span class="text-red-600">*</span></label>
                    <input type="text" name="employee_id" value="{{ old('employee_id') }}"
                           class="w-full rounded-xl border @error('employee_id') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                           required placeholder="EMP0001">
                    @error('employee_id') <p class="text-xs text-red-600 mt-1">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">First Name <span class="text-red-600">*</span></label>
                    <input type="text" name="first_name" value="{{ old('first_name') }}"
                           class="w-full rounded-xl border @error('first_name') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                           required>
                    @error('first_name') <p class="text-xs text-red-600 mt-1">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Last Name</label>
                    <input type="text" name="last_name" value="{{ old('last_name') }}"
                           class="w-full rounded-xl border border-gray-300 px-3 py-2">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Email <span class="text-red-600">*</span></label>
                    <input type="email" name="email" value="{{ old('email') }}"
                           class="w-full rounded-xl border @error('email') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                           required placeholder="nama@perusahaan.com">
                    @error('email') <p class="text-xs text-red-600 mt-1">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Birthdate <span class="text-red-600">*</span></label>
                    <input type="date" name="date_of_birth" value="{{ old('date_of_birth') }}"
                           class="w-full rounded-xl border @error('date_of_birth') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                           required>
                    @error('date_of_birth') <p class="text-xs text-red-600 mt-1">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Gender</label>
                    <select name="gender"
                            class="w-full rounded-xl border @error('gender') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2">
                        <option value="">-- Pilih --</option>
                        @foreach(($genders ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ old('gender') == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('gender') <p class="text-xs text-red-600 mt-1">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Marital Status <span class="text-red-600">*</span></label>
                    <select name="marital_status"
                            class="w-full rounded-xl border @error('marital_status') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($maritals ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ old('marital_status') == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('marital_status') <p class="text-xs text-red-600 mt-1">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Religion <span class="text-red-600">*</span></label>
                    <select name="religion"
                            class="w-full rounded-xl border @error('religion') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($religs ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ old('religion') == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('religion') <p class="text-xs text-red-600 mt-1">{{ $message }}</p> @enderror
                </div>
            </div>
        </section>

        {{-- ================= EMPLOYMENT ================= --}}
        <section class="bg-white rounded-2xl shadow-sm border border-gray-100">
            <div class="px-5 py-4 border-b border-gray-100">
                <h3 class="font-semibold text-gray-900">Informasi Employment</h3>
                <p class="text-sm text-gray-500">Pemetaan organisasi & status kerja.</p>
            </div>

            <div class="p-5 grid grid-cols-1 md:grid-cols-2 gap-5">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Branch <span class="text-red-600">*</span></label>
                    <select name="branch"
                            class="w-full rounded-xl border @error('branch') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($branches ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ old('branch') == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }} @if(($opt['id'] ?? '')!=='') (ID: {{ $opt['id'] }}) @endif
                            </option>
                        @endforeach
                    </select>
                    @error('branch') <p class="text-xs text-red-600 mt-1">{{ $message }}</p> @enderror
                    <p class="text-xs text-gray-500 mt-1">Pilih persis “Pusat” (sesuai master sandbox).</p>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Organization <span class="text-red-600">*</span></label>
                    <select name="organization_name"
                            class="w-full rounded-xl border @error('organization_name') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($orgs ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ old('organization_name') == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('organization_name') <p class="text-xs text-red-600 mt-1">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Job Position <span class="text-red-600">*</span></label>
                    <select name="job_position"
                            class="w-full rounded-xl border @error('job_position') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($jobs ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ old('job_position') == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('job_position') <p class="text-xs text-red-600 mt-1">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Job Level <span class="text-red-600">*</span></label>
                    @if(!empty($levels))
                        <select name="job_level"
                                class="w-full rounded-xl border @error('job_level') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                                required>
                            <option value="">-- Pilih --</option>
                            @foreach($levels as $opt)
                                <option value="{{ $opt['name'] }}" {{ old('job_level') == $opt['name'] ? 'selected' : '' }}>
                                    {{ $opt['name'] }}
                                </option>
                            @endforeach
                        </select>
                    @else
                        <input type="text" name="job_level" value="{{ old('job_level') }}"
                               class="w-full rounded-xl border @error('job_level') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                               required placeholder='mis. "Manager" (master job level kosong)'>
                        <p class="text-xs text-gray-500 mt-1">Master Job Level kosong di Sandbox—isi manual.</p>
                    @endif
                    @error('job_level') <p class="text-xs text-red-600 mt-1">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Employment Status <span class="text-red-600">*</span></label>
                    <select name="employment_status"
                            class="w-full rounded-xl border @error('employment_status') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($emps ?? []) as $opt)
                            <option value="{{ $opt['id'] }}" {{ old('employment_status') == $opt['id'] ? 'selected' : '' }}>
                                {{ $opt['name'] }} (ID: {{ $opt['id'] }})
                            </option>
                        @endforeach
                    </select>
                    @error('employment_status') <p class="text-xs text-red-600 mt-1">{{ $message }}</p> @enderror
                    <p class="text-xs text-gray-500 mt-1">Contract (ID=2) wajib isi End Date.</p>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">End Employment Status Date</label>
                    <input type="date" name="end_employment_status_date" value="{{ old('end_employment_status_date') }}"
                           class="w-full rounded-xl border @error('end_employment_status_date') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2">
                    @error('end_employment_status_date') <p class="text-xs text-red-600 mt-1">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Join Date <span class="text-red-600">*</span></label>
                    <input type="date" name="join_date" value="{{ old('join_date') }}"
                           class="w-full rounded-xl border @error('join_date') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                           required>
                    @error('join_date') <p class="text-xs text-red-600 mt-1">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Schedule <span class="text-red-600">*</span></label>
                    <select name="schedule"
                            class="w-full rounded-xl border @error('schedule') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($schedules ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ old('schedule') == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('schedule') <p class="text-xs text-red-600 mt-1">{{ $message }}</p> @enderror
                </div>
            </div>
        </section>

        {{-- ================= COMPENSATION & TAX ================= --}}
        <section class="bg-white rounded-2xl shadow-sm border border-gray-100">
            <div class="px-5 py-4 border-b border-gray-100">
                <h3 class="font-semibold text-gray-900">Kompensasi & Pajak</h3>
                <p class="text-sm text-gray-500">Isi gaji pokok & status PTKP. Lainnya default di controller.</p>
            </div>

            <div class="p-5 grid grid-cols-1 md:grid-cols-2 gap-5">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Basic Salary <span class="text-red-600">*</span></label>
                    <input type="number" min="0" step="1" name="basic_salary" value="{{ old('basic_salary') }}"
                           class="w-full rounded-xl border @error('basic_salary') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                           required placeholder="5000000">
                    @error('basic_salary') <p class="text-xs text-red-600 mt-1">{{ $message }}</p> @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">PTKP Status <span class="text-red-600">*</span></label>
                    <select name="ptkp_status"
                            class="w-full rounded-xl border @error('ptkp_status') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                            required>
                        <option value="">-- Pilih --</option>
                        @foreach(($ptkps ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ old('ptkp_status') == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('ptkp_status') <p class="text-xs text-red-600 mt-1">{{ $message }}</p> @enderror
                </div>

                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700 mb-1">NPP BPJS Ketenagakerjaan</label>
                    <input type="text" name="npp_bpjs_ketenagakerjaan" value="{{ old('npp_bpjs_ketenagakerjaan') }}"
                           class="w-full rounded-xl border border-gray-300 px-3 py-2"
                           placeholder='kosongkan → controller akan kirim "default"'>
                    @error('npp_bpjs_ketenagakerjaan') <p class="text-xs text-red-600 mt-1">{{ $message }}</p> @enderror
                </div>
            </div>
        </section>

        {{-- ================= ACTIONS ================= --}}
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-4 md:sticky md:bottom-4">
            <div class="flex flex-col md:flex-row items-stretch md:items-center justify-between gap-3">
                <p class="text-sm text-gray-500">Pastikan data sudah benar sebelum disimpan.</p>
                <div class="flex items-center gap-3">
                    <a href="{{ route('talenta.sandbox.employees.index') }}"
                       class="inline-flex items-center justify-center px-4 py-2 rounded-xl border border-gray-200 hover:bg-gray-50">
                        Batal
                    </a>
                    <button type="submit"
                            class="inline-flex items-center justify-center px-4 py-2 rounded-xl text-white bg-primary hover:opacity-90">
                        Simpan Karyawan
                    </button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection
